;*=====================================================================*
;*                                                                     *
;*                 Copyright (c) 1993-2003 nVIDIA Corp.                *
;*                              ALL RIGHTS RESERVED                    *
;*                                                                     *
;*    This program contains proprietary and confidential information.  *
;*    No part of this  material may be reproduced or copied in any     *
;*    tangible medium, or stored in a retrieval system, or transmitted *
;*    in any form without the prior written permission of nVIDIA Corp. *
;*                                                                     *
;*=====================================================================*
;----------------------------------------------------------------------------
;Rev    Date     Name    Description
;----------------------------------------------------------------------------
;N08    09/16/03 YW     Added new function interface 2Ah for GetDimmAddrInfo
;N07    07/23/03 YW     Sync this file with wpt.inc under nvaward tree.
;N06    06/09/03 YW     Removed FSB frequency cmos location and bitmap.
;                       NVTweak will use PCI reg 548h to get FSB speed.
;N05    06/09/03 YW     Added FSB frequency cmos locatin and bitmap to 
;                       GetCMOSLocation0.  Also added OEM_SUBFUNCTION_SUPPORT
;                       to indicate if OEM sub-function is supported or not
;                       in BIOS.
;N04    06/06/03 YW     Added MACRO for setup function code in the end of post.
;                       This MACRO should be used if OEM uses a function code
;                       other than 0C8h.
;N03    05/29/03 YW     Changed CMOS interface between WPT and BIOS.
;N02    04/01/03 YW     Swap cpu and mother temperature offset.
;N01    03/28/03 YW     Initial version. Constants are used in wptapi.asm
;
                                                   
WPT_INTERFACE_VERSION           EQU     0100h ;Version for WPT interface
OEM_SUBFUNCTION_SUPPORT         EQU     0000h; Not support, 0001h means support ; N05

ifdef K8_CPU_SUPPORT
SMBUS_PORT2                     EQU     SMBus2_Port      ;defined in K8 bios.cfg.
else
SMBUS_PORT2                     EQU     SMBus_Port_2    ;defined in C17/C18 bios.cfg
endif

SUPERIO_GPIO_PORT_BASE          EQU     Superio_GPIO_Port;IO mapped superIO base

HW_MONITOR_SMBUS_READ_ADDR      EQU     5Bh ;SMBUS address for read hardware monitor data
HW_MONITOR_SMBUS_WRITE_ADDR     EQU     5Ah ;SMBUS address for read hardware monitor data

SMSC_LPC47M15_SMB_REG_CONFIGURATION     EQU     40h     ;HW monitor config register.
CPU_TEMP_SMBUS_OFFSET           EQU     26h ;SMBUS offset coresponding to CPU Temp            ;N02
BOARD_TEMP_SMBUS_OFFSET         EQU     27h ;SMBUS offset coresponding to Motherboard Temp    ;N02

CPU_TEMP_THRESHOLD              EQU     90  ; 90 celsius for CPU warning threshold.           ;N07
MB_TEMP_THRESHOLD               EQU     43  ; 43 celsius for motherboard warning threshold.   ;N07

VOLTMARGINEN_GPIO43_CTRL        EQU     3Eh ;Voltage Margin out enable (GPIO 43) control register.
VOLTMARGINEN_GPIO_GROUP         EQU     4Eh ;Voltage Margin out enable (GPIO 43) Data register
VOLTMARGINEN_GPIOMASK           EQU     08h                                                   ;N07
MARGINOUTEN_ENABLE_STATUS       EQU     00h
MARGINOUTEN_ENABLE_BIT          EQU     3   ;Bit 3

GPIO_CTRL_OUTPUT                EQU     00h ;Default GPIO control register value
GPIO_VID_CTRL_OUTPUT            EQU     80h ;Default GPIO control register value for CPU VID control
GPIO_CTRL_OUTPUT_MASK           EQU     05h 


AUX_MARGIN1_GPIO12_CTRL         EQU     25h
AUX_MARGIN2_GPIO17_CTRL         EQU     2Ah
AUX_GPIO_GROUP                  EQU     4Bh
AUX_GPIOMASK                    EQU     84h
AUX_DEFAULT_VOLTAGE_1500        EQU     3FC00000h       ;Default is 1.5v
AUX_MARGIN1_DEFAULT_STATUS      EQU     00h
AUX_MARGIN1_BIT                 EQU     2       ;Bit 2
AUX_MARGIN2_DEFAULT_STATUS      EQU     00h
AUX_MARGIN2_BIT                 EQU     7       ;Bit 7

MCP2_GPIO39_REG                 EQU     0E7h    ;GPIO register for smb_alert                   ;N07
      
MEM_MARGIN1_GPIO15_CTRL         EQU     28h
MEM_MARGIN2_GPIO16_CTRL         EQU     29h
MEM_GPIO_GROUP                  EQU     4Bh
MEM_GPIOMASK                    EQU     60h
MEM_DEFAULT_VOLTAGE_2600        EQU     40266666h       ;Default is 2.6v
MEM_MARGIN1_DEFAULT_STATUS      EQU     20h
MEM_MARGIN1_BIT                 EQU     5       ;Bit 5
MEM_MARGIN2_DEFAULT_STATUS      EQU     40h
MEM_MARGIN2_BIT                 EQU     6       ;Bit 6


AGP_MARGIN1_GPIO13_CTRL         EQU     26h
AGP_MARGIN2_GPIO14_CTRL         EQU     27h
AGP_GPIO_GROUP                  EQU     4Bh
AGP_GPIOMASK                    EQU     18h
AGP_DEFAULT_VOLTAGE_1500        EQU     3FC00000h       ;Default is 1.5v
AGP_MARGIN1_DEFAULT_STATUS      EQU     08h
AGP_MARGIN1_BIT                 EQU     3       ;Bit 3
AGP_MARGIN2_DEFAULT_STATUS      EQU     10h
AGP_MARGIN2_BIT                 EQU     4       ;Bit 4

CSCORE_MARGIN1_GPIO10_CTRL      EQU     23h
CSCORE_MARGIN2_GPIO11_CTRL      EQU     24h
CSCORE_GPIO_GROUP               EQU     4Bh
CSCORE_GPIOMASK                 EQU     03h
CSCORE_DEFAULT_VOLTAGE_1500     EQU     3FC00000h       ;Default is 1.5v
CSCORE_MARGIN1_DEFAULT_STATUS   EQU     01h
CSCORE_MARGIN1_BIT              EQU     0       ;Bit 0
CSCORE_MARGIN2_DEFAULT_STATUS   EQU     02h
CSCORE_MARGIN2_BIT              EQU     1       ;Bit 1


VID_OVERRIDE_GPIO55_CTRL        EQU     44h ;VID override enable (GPIO 55) control register.
VID_OVERRIDE_GPIO_GROUP         EQU     4Fh ;VID override enable (GPIO 55) Data reg.
VID_OVERRIDE_GPIOMASK           EQU     20h ;bit 5 is for GPIO 55
CPUVID_OVERRIDE0_GPIO25_CTRL    EQU     30h
CPUVID_OVERRIDE1_GPIO26_CTRL    EQU     31h
CPUVID_OVERRIDE2_GPIO20_CTRL    EQU     2Bh
CPUVID_OVERRIDE3_GPIO21_CTRL    EQU     2Ch
CPUVID_OVERRIDE4_GPIO22_CTRL    EQU     2Dh
CPUVID_GPIO_GROUP               EQU     4Ch
CPUVID_GPIOMASK                 EQU     67h
CPU_VID_SMBUS_OFFSET            EQU     47h             ;SMBUS Offset to read VID bit 0-3
CPU_VID4_SMBUS_OFFSET           EQU     49h             ;SMBUS offset to read VID bit 4
CPUVID0_GPIO_BIT                EQU     5       ;gpio 25
CPUVID1_GPIO_BIT                EQU     6
CPUVID2_GPIO_BIT                EQU     0
CPUVID3_GPIO_BIT                EQU     1
CPUVID4_GPIO_BIT                EQU     2
CPUVID_DEFAULT_STATUS           EQU     0

FAN1_GPIO33_CTRL_INDEX          EQU     36h
FAN2_GPIO32_CTRL_INDEX          EQU     35h
C17_FAN2_CTRL_ENABLE            EQU     04h     ;C17 board uses 04h ;dynamicly update in code.
C18D_FAN2_CTRL_ENABLE           EQU     06h     ;C18D board uses 06h ;dynamicly update in code.
FAN1_POWER_INDEX                EQU     56h
FAN2_POWER_INDEX                EQU     57h
FAN_FULL_POWER                  EQU     0FFh
FAN_POWER_MASK                  EQU     7Eh

FAN1_TACHO_GP31_CTRL_INDEX      EQU     34h
FAN2_TACHO_GP30_CTRL_INDEX      EQU     33h
FAN_CONTROL                     EQU     58h

FAN1_TACHO_GP31_REG             EQU     59h
FAN2_TACHO_GP30_REG             EQU     5Ah
FAN1_PRELOAD_REG                EQU     5Bh
FAN2_PRELOAD_REG                EQU     5Ch

FAN_TACHO_FREQ                  EQU     1DFFB0h

;SMI related define
SMI_IO_BASE_ADDR                EQU     SYSTEM_PORT
SW_SMI_STATUS_REG               EQU     2Fh
SW_SMI_SCRATCH0_REG             EQU     80h         ;N03
SW_SMI_SCRATCH1_REG             EQU     84h
SW_SMI_SCRATCH2_REG             EQU     88h         ;N03
SW_SMI_SCRATCH3_REG             EQU     8Ch         ;N03
SW_SMI_SCRATCH4_REG             EQU     90h         ;N03
SW_SMI_SCRATCH5_REG             EQU     94h         ;N03
SW_SMI_SCRATCH6_REG             EQU     98h         ;N03
SW_SMI_SCRATCH7_REG             EQU     9Ch         ;N03

; Function return code   
WPT_RETURN_INVALID              EQU     0FFh
WPT_RETURN_FAIL                 EQU     0FEh
WPT_RETURN_SUCCESS              EQU     000h

;N03 start
ifndef K8_CPU_SUPPORT
                                
;CMOS performance related definition
SYSPERFORMACE_CMOS              EQU     SysPerf_CMOS
SYSPERFORMACE_CMOS_BIT          EQU     SysPerf_CMOS_BIT

CPU_INTERFACE_CMOS              EQU     CpuInterface_CMOS
CPU_INTERFACE_CMOS_BIT          EQU     CpuInterface_CMOS_BIT

MEMORYTIMING_CMOS               EQU     MemTimingMode_CMOS
MEMORYTIMING_CMOS_BIT           EQU     MemTimingMode_CMOS_BIT

MEM_TRAS_CMOS                   EQU     MemTimingRAS_CMOS
MEM_TRAS_CMOS_BIT               EQU     MemTimingRAS_CMOS_BIT

MEM_TRCD_CMOS                   EQU     MemTimingRCD_CMOS
MEM_TRCD_CMOS_BIT               EQU     MemTimingRCD_CMOS_BIT

MEM_TRP_CMOS                    EQU     MemTimingRP_CMOS
MEM_TRP_CMOS_BIT                EQU     MemTimingRP_CMOS_BIT

CASLATENCY_CMOS                 EQU     CAS_OD_CMOS
CASLATENCY_CMOS_BIT             EQU     CAS_OD_CMOS_Bits

;Current is disabled because not sure if it is supported.
;CMOS over voltage related definition
VAUX_CMOS                       EQU     0FFh
VAUX_CMOS_BIT                   EQU     0
VCORE_CMOS                      EQU     0FFh
VCORE_CMOS_BIT                  EQU     0
VAGP_CMOS                       EQU     0FFh
VAGP_CMOS_BIT                   EQU     0
VMEM_CMOS                       EQU     0FFh
VMEM_CMOS_BIT                   EQU     0
CPUVID_CMOS                     EQU     0FFh
CPUVID_CMOS_BIT                 EQU     0

AGP_8X_SUPPORT_CMOS             EQU     AGP_8X_CMOS
AGP_8X_SUPPORT_CMOS_BIT         EQU     AGP_8X_CMOS_Bits

else
;CMOS performance related definition
SYSPERFORMACE_CMOS              EQU     SysPerf_CMOS
SYSPERFORMACE_CMOS_BIT          EQU     SysPerf_CMOS_BIT

CPU_INTERFACE_CMOS              EQU     0FFh
CPU_INTERFACE_CMOS_BIT          EQU     0

MEMORYTIMING_CMOS               EQU     0FFh
MEMORYTIMING_CMOS_BIT           EQU     0

MEM_TRAS_CMOS                   EQU     Tras_CMOS
MEM_TRAS_CMOS_BIT               EQU     Tras_CMOS_BIT

MEM_TRCD_CMOS                   EQU     Trcd_CMOS
MEM_TRCD_CMOS_BIT               EQU     Trcd_CMOS_BIT

MEM_TRP_CMOS                    EQU     Trp_CMOS
MEM_TRP_CMOS_BIT                EQU     Trp_CMOS_BIT

CASLATENCY_CMOS                 EQU     Tcl_CMOS
CASLATENCY_CMOS_BIT             EQU     Tcl_CMOS_BIT

;Current is disabled because not sure if it is supported.
;CMOS over voltage related definition
VAUX_CMOS                       EQU     0FFh
VAUX_CMOS_BIT                   EQU     0
VCORE_CMOS                      EQU     0FFh
VCORE_CMOS_BIT                  EQU     0
VAGP_CMOS                       EQU     0FFh
VAGP_CMOS_BIT                   EQU     0
VMEM_CMOS                       EQU     0FFh
VMEM_CMOS_BIT                   EQU     0
CPUVID_CMOS                     EQU     0FFh
CPUVID_CMOS_BIT                 EQU     0

AGP_8X_SUPPORT_CMOS             EQU     0FFh
AGP_8X_SUPPORT_CMOS_BIT         EQU     0

endif ;K8_CPU_SUPPORT

;CMOS Boot device order related definition
FIRST_BOOT_DEVICE_CMOS          EQU     First_Boot_CMOS
FIRST_BOOT_DEVICE_CMOS_BIT      EQU     00001111b

SECOND_BOOT_DEVICE_CMOS         EQU     First_Boot_CMOS
SECOND_BOOT_DEVICE_CMOS_BIT     EQU     11110000b

THIRD_BOOT_DEVICE_CMOS          EQU     Third_Boot_CMOS
THIRD_BOOT_DEVICE_CMOS_BIT      EQU     00001111b


;CMOS misc performance related definition
CPU_INTERNAL_CACHE_CMOS         EQU     CACHE_CONTROL
CPU_INTERNAL_CACHE_CMOS_BIT     EQU     00000010b

CPU_EXTERNAL_CACHE_CMOS         EQU     CACHE_CONTROL
CPU_EXTERNAL_CACHE_CMOS_BIT     EQU     00000001b


;Currently is disabled because not sure if it is supported. 
SSE_INSTRUCTION_CMOS            EQU     0FFh
SSE_INSTRUCTION_CMOS_BIT        EQU     0

AGP_APERATURE_CMOS              EQU     CF_CMOS
AGP_APERATURE_CMOS_BIT          EQU     11100000b

CLOCK_MULTIPLIER_CMOS           EQU     0FFh                    ;N07   
CLOCK_MULTIPLIER_CMOS_BIT       EQU     0                       ;N07   

ifdef K8_CPU_SUPPORT

AGP20_SPEED_CMOS                EQU     Agp20Speed_Cmos
AGP20_SPEED_CMOS_BIT            EQU     Agp20Speed_Cmos_Bits

AGP30_SPEED_CMOS                EQU     Agp30Speed_Cmos
AGP30_SPEED_CMOS_BIT            EQU     Agp30Speed_Cmos_Bits

LDT_SPEED_CMOS                  EQU     LDT_FREQ_CMOS
LDT_SPEED_CMOS_BIT              EQU     LDT_FREQ_BITS

endif ;K8_CPU_SUPPORT
;N03 end

;N07 start
BOARD_VENDOR_ID                 EQU     01h     ; NVidia           
BOARD_VERSION                   EQU     200h    ; 2.0               
                                                                    
ifdef K8_CPU_SUPPORT                                                
BOARD_MODEL1                    EQU     "NVK8"                      
BOARD_MODEL2                    EQU     "-CRB"                      
else                                                                
BOARD_MODEL1                    EQU     "NVK7"                      
BOARD_MODEL2                    EQU     "-CRB"                      
endif ;K8_CPU_SUPPORT                                               
;N07 end

;Software SMI command.  Used in MCP_PM_SWISMI_REGISTER
NV_WPT                          EQU     0C8h

;Voltage table end indicator    
VOLTAGE_TABLE_END               EQU     80000000h        

;N08 start
;Used for GetDimmAddrInfo
DIMM0_SMBUSADDR                 EQU     50h     ;Smbus address
DIMM0_SLOT_NO                   EQU     0       ;Corresponding slot no.
DIMM0_SMBUS_SEG                 EQU     0       ; smbus segment                   
DIMM1_SMBUSADDR                 EQU     51h     
DIMM1_SLOT_NO                   EQU     1
DIMM1_SMBUS_SEG                 EQU     0                          
DIMM2_SMBUSADDR                 EQU     0     
DIMM2_SLOT_NO                   EQU     2
DIMM2_SMBUS_SEG                 EQU     0                          
DIMM3_SMBUSADDR                 EQU     0     
DIMM3_SLOT_NO                   EQU     3
DIMM3_SMBUS_SEG                 EQU     0                          
;N08 end
                                                     
;N04 start
; This macro should be used in the end of POST to set correct function code.
; NVTweak will get function code from scratch register 7 and use it to access
; WPT functions.                                                                                   
SetWPTFncCode MACRO             ;This macro should be used when stack is available.
        push    dx
        push    ax
        mov     dx, SMI_IO_BASE_ADDR + 9Fh       ;Scratch register 7 bit 24-31.
        mov     al, NV_WPT
        out     dx, al
        pop     ax
        pop     dx
ENDM        
;N04 end

